<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowDetailPage()
  ===================================================*/

  function ShowDetailPage() {

    // vars global configuration
    global $dbConn, $theme_name, $theme_path, $rev_max_rows, $category_separator;

    // vars url & form
    global $id;

    // vars messages
    global $msg;

    // vars template
    global $link_detail, $pagination, $review_rows, $ofc_review;

    global $linkid;

    global $page_title, $link_id, $category_id, $category_name,
           $category_path, $category_path_with_link;


    $tpl = new Template();

    if (empty($id))
      $id = $linkid;

    $links_obj = new clsLink;
    $links_obj->query                 = "select * from idx_link where link_id = '$id'";
    $links_obj->table_name            = "idx_link";
    $links_obj->category_table_name   = "idx_category";
    $links_obj->review_table_name     = "idx_review";
    $links_obj->category_separator    = $category_separator;
    $links_obj->max_rows              = 1;
    $links_obj->rating_image_path     = "themes/" . $theme_name . "/images/rating/";
    $links_obj->rev_rating_image_path = "themes/" . $theme_name . "/images/review/";
    $links_obj->date_format           = $msg["10161"];
    $links_obj->template_file         = $theme_path . "detail_link.html";
    $link_detail                      = $links_obj->Display();


    // official review
    $query      = "select official_review, category_id from idx_link where link_id = '$id'";
    $result     = $dbConn->Execute($query);
    $ofc_review = $result->Fields("official_review");
    $category_id = $result->Fields("category_id");

    if (!empty($ofc_review)) {
      $ofc_review_html = $msg["10163"];

      if (empty($ofc_review_html))
        $ofc_review_html = '<%$ofc_review%>';
    }

    $tpl->assign('ofc_review', $ofc_review);
    $ofc_review = $tpl->fetch('var:' . $ofc_review_html);

    // review

    $links_obj->pg_size       = $rev_max_rows;
    $links_obj->href          = "detail.php";
    $links_obj->more_param    = "&linkid=$id";
    $links_obj->template_file = $theme_path . "review_rows.html";

    if ($links_obj->GetNumberOfReview($id) > 0) {

      // get avg_review
      global $num_review, $avg_review, $avg_review_image;

      $query      = "select reviews, avg_review from idx_link where link_id = '$id'";
      $result2    = $dbConn->Execute($query);
      $avg_review = $result2->Fields("avg_review");
      $num_review = $result2->Fields("reviews");
      $avgr       = $avg_review * 2;

      if (round($avgr) == 1)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "0half.gif" . ">";
      elseif (round($avgr) == 2)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "0.gif" . ">";
      elseif (round($avgr) == 3)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "1half.gif" . ">";
      elseif (round($avgr) == 4)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "2.gif" . ">";
      elseif (round($avgr) == 5)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "2half.gif" . ">";
      elseif (round($avgr) == 6)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "3.gif" . ">";
      elseif (round($avgr) == 7)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "3half.gif" . ">";
      elseif (round($avgr) == 8)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "4.gif" . ">";
      elseif (round($avgr) == 9)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "4half.gif" . ">";
      elseif (round($avgr) == 10)
        $avg_review_image = "<img src=" . "themes/" . $theme_name . "/images/review/" . "5.gif" . ">";

      $tpl               = new Template;
      $tpl->assign('avg_review', $avg_review);
      $tpl->assign('num_review', $num_review);
      $tpl->assign('avg_review_image', $avg_review_image);
      $review_header     = $tpl->fetch('var:' . $msg["10162"]);
      $links_obj->header = $review_header;
      $review_rows       = $links_obj->header;
      $review_rows      .= $links_obj->DisplayReview($id);
    }

    $pagination = $links_obj->pagination;


    $link_id = $id;

    $query = "select name
              from idx_category
              where category_id = '$category_id'";
    $row = $dbConn->FetchOne($query);
    $category_name = $row['name'];

    $query = "select path, path_with_url
              from idx_category_path
              where category_id = '$category_id'";
    $row = $dbConn->FetchOne($query);
    $category_path = $row['path'];
    $category_path_with_link = $row['path_with_url'];

    DisplayTemplate($theme_path . "detail.html",
                    "\$page_title,\$avg_review,\$num_review,\$avg_review_image,\$link_detail,".
                    "\$pagination,\$review_rows,\$ofc_review,\$link_id,".
                    "\$category_id,\$category_name,\$category_path,\$category_path_with_link");
  }


  /*===================================================
    main
  ===================================================*/

  include "application.php";

  AddFilter("page_cache");
  RunPreFilter(__FILE__);

  if (!defined('CACHED_PAGE')) {
    if (empty($id)) {
      $id = $linkid;
    }
    $query      = "select title, suspended from idx_link where link_id = '$id'";
    $result     = $dbConn->Execute($query);
    $link_title = $result->Fields("title");
    $suspended  = $result->Fields("suspended");
    $page_title = $link_title;

    // check if suspended
    if ($suspended) {
      DisplayTemplate($theme_path . "suspended.html");
      RunPostFilter(__FILE__);
    }

    ShowDetailPage();
  }

  RunPostFilter(__FILE__);

?>